require("scripts/chocshopstyle.lua");

origin_x = 35;
origin_y = 40;
window_width = 275;
window_height = 150;

MakeDialog{

   name = "achievement_dialog",
    
   VRewardNotify {
        name = "reward_notify",
        duration = 7000,
        transition = 500,
        
        x = 800 - window_width, 
        y = 0,
        w = window_width, 
        h = window_height,

        spacing = 10,
        
        background = {
            x = window_width, 
            y = 0,
            w = window_width+8, 
            h = window_height,
            x1 = 30, y1 = 32,
            x2 = 37, y2 = 40,
            assets = {
                background = {
                    { state="default", file = "ui/backgrounds/split9_dialog_small", anim=false },    
                },
            },
            text = {
                title = {
                    font = {edwardian_medium, 22, WhiteColor},
                    x = 0, y = 5, w = window_width, h = 40,
                    flags = kVAlignCenter + kHAlignCenter,
                    label = "#New Achievements",
                },
            },
        },
        item = {
            x = origin_x, 
            y = origin_y, 
            w = window_width - origin_x - 10, 
            h = window_height - origin_y*2,
            x1 = 9, y1 = 5,
            x2 = 0, y2 = 4,
            blend = kBlendAdditiveAlpha,
            baseDir = "ui/backgrounds/",
            assets = {
                background = {
                    { state = "default", file="split9_gradient", anim=false }, 
                },
            },
            children = {
                baseDir = "ui/rewards/small/",
                icon = {
                    name = "icon",
                    assets = {
                        anim = false,
                        icon = {
                            { state="delivery10",           file="reward_almond_joy" },
                            { state="truffle50",            file="reward_almond_paste" },
                            { state="complete_kamchatka",   file="reward_gold_box" },
                            { state="served100",            file="reward_blueberries" },
                            { state="disposed1000",         file="reward_boat" },
                            { state="sauce1000",            file="reward_bow_tie" },
                            { state="infusion50",           file="reward_brown_swirly_top" },
                            { state="earnings5000",         file="reward_b_square" },
                            { state="complete_krakatoa",    file="reward_cake" },
                            { state="disposed1",            file="reward_carmellowswirl" },
                            { state="truffle1",             file="reward_choco_swirl_crunch" },
                            { state="disposed100",          file="reward_cinnamon_bell" },
                            { state="mastered25",           file="reward_coffee_cup" },
                            { state="complete_namche",      file="reward_crown_royale" },
                            { state="sauce100",             file="reward_dollup" },
                            { state="complete_grytviken",   file="reward_flat_berry" },
                            { state="bars10",               file="reward_flower" },
                            { state="served50",             file="reward_foggy_mint" },
                            { state="complete_gaberoun",    file="reward_blimp" },
                            { state="infusion1000",         file="reward_green_ball" },
                            { state="angry100",             file="reward_heart" },
                            { state="earnings10000",        file="reward_horse_crazy" },
                            { state="angry1000",            file="reward_indian_cocowand" },
                            { state="endless4",             file="reward_lucky_horseshoe" },
                            { state="endless1",             file="reward_milk_white_streak" },
                            { state="served10",             file="reward_mint_crumble" },
                            { state="earnings100000",       file="reward_orange_foil" },
                            { state="served1000",           file="reward_puck" },
                            { state="mastered60",           file="reward_pyramid" },
                            { state="infusion100",          file="reward_raspberry" },
                            { state="bars1000",             file="reward_red_foil" },
                            { state="angry20",              file="reward_red_velvet_sting" },
                            { state="truffle100",           file="reward_smaller_copy" },
                            { state="infusion1",            file="reward_sprinkled_chocolate" },
                            { state="endless2",             file="reward_square" },
                            { state="truffle1000",          file="reward_star" },
                            { state="mastered50",           file="reward_strawberry" },
                            { state="sauce20",              file="reward_striped_round_choco" },
                            { state="earnings1mil",         file="reward_swan" },
                            { state="delivery1",            file="reward_swirl" },
                            { state="earnings1000",         file="reward_swirly_top" },
                            { state="delivery50",           file="reward_tower" },
                            { state="earnings50000",        file="reward_white_aligator" },
                            { state="disposed20",           file="reward_white_one" },
                            { state="complete_iquitos",     file="reward_white_round" },
                            { state="endless3",             file="reward_white_with_swirl" },
                            { state="angry1",               file="reward_yellow_foil" },
                            { state="mastered10",           file="reward_yellow_line_cake" },
                            { state="bars100",              file="reward_zebra_mint" },
                            { state="delivery25",           file="reward_zeppelin" },
                        },
                    },
                    children = {
                        circle = {
                            layer = -1,
                            assets = {
                                default = {
                                    { state = "default", file="circle", anim=false },
                                },
                            },
                        },
                    },
                },
            },
            text = {
                header = {
                    x = 0, 
                    y = 0, 
                    w = window_width - origin_x - 10, 
                    h = 16, 
                    font = {edwardian_medium, 15, WhiteColor},
                    flags = kVAlignTop + kHAlignLeft,
                    margin = {18,0,0,0},
                },
                description = {
                    x = 0, 
                    y = 16,
                    w = window_width - origin_x - 10, 
                    h = window_height - origin_y*2 - 16,
                    font = {edwardian_medium, 13, WhiteColor},
                    flags = kVAlignTop + kHAlignLeft,
                    margin = {25,0,0,0},
                },
            },
        },
    },
}